--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNvehicleParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspVehicleFilter    FUNobj = (getAppData FUNobj 422 == "1")

  fn DYNFUNvehicleParams FUNobj =
  (
    --- Make Material Channel Name Array
    local LOCmatAr = #("1","2","3","4","5","6","7","8","9")
    local LOCarray = DYNFUNgetmatchannelnames FUNobj.material true true DYNINImatIDlimit
    if LOCarray.count >= 9 then (for i = 1 to 9 do LOCmatAr[i] = LOCarray[i])
    --- Continue with function
    DYNvehicleParams.LOCobj                     = FUNobj

    local LOCselectedVehicle                    = try (getFilenameFile (getAppData FUNobj 424)) catch ("")
    if LOCselectedVehicle != "" then
    (
      local LOCvehLibArray                        = DYNFUNgetfiles (DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameVehicles + "\\") 1 "*.ini"
      DYNvehicleParams.DDVISvehType.items         = LOCvehLibArray
      DYNvehicleParams.DDVISvehType.selection     = findItem LOCvehLibArray LOCselectedVehicle
      DYNvehicleParams.DDVISvehType.enabled       = true
    )
    else
    (
      DYNvehicleParams.DDVISvehType.items         = #()
      DYNvehicleParams.DDVISvehType.selection     = 0
      DYNvehicleParams.DDVISvehType.enabled       = false
    )

    local LOCselectedMatChannel                   = try ((getAppData FUNobj 423) as integer) catch (0)
    DYNvehicleParams.DDVISobjectParam.items       = LOCmatAr
    DYNvehicleParams.DDVISobjectParam.selection   = LOCselectedMatChannel

    if classOf FUNobj == editable_Mesh or classOf FUNobj == Editable_Poly then
    (
      DYNvehicleParams.DDVISobjectParam.enabled = if LOCselectedMatChannel > 0 then (true) else (false)
    )
    else
    (
      DYNvehicleParams.DDVISobjectParam.enabled = false
    )

    if FUNobj.boxMode             then DYNvehicleParams.CKDYNdisplayBox.checked = true else DYNvehicleParams.CKDYNdisplayBox.checked = false
    if FUNobj.castShadows         then DYNvehicleParams.CKDYNcastShadow.checked = true else DYNvehicleParams.CKDYNcastShadow.checked = false

    --- Disable controls if assigned material isn't as expected. This should only happen if another material was pre-assigned in object libraries
    if (try (striCmp (subString FUNobj.material.name 1 DYNmatNameVehicles.count) DYNmatNameVehicles != 0) catch (false)) then
    (
      for i in DYNvehicleParams.controls do i.enabled = false
      DYNvehicleParams.CKDYNcastShadow.enabled = true
      DYNvehicleParams.CKDYNdisplayBox.enabled = true
      DYNvehicleParams.DDVISobjectParam.items  = #()
    )

    --- If Vehicle Object INI File Definition does not exist, disable DROPDOWN list
    --- This can occur when the wrong country kit is currently loaded
    --- disable vehicle mesh changer for the moment
    local LOCswitch = false
    DYNvehicleParams.DDVISvehType.enabled = LOCswitch

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNvehicleParams FUNobj
  )


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01         width:(DYNiniExplorerWidth - 21) pos:[4,7]    height:48
  dropdownlist DDVISvehType     width:(DYNiniExplorerWidth - 35) pos:[11,26]

  groupbox GBDYNgroup02         width:(DYNiniExplorerWidth - 21) pos:[4,59]   height:48
  dropdownlist DDVISobjectParam width:(DYNiniExplorerWidth - 35) pos:[11,78]


  groupbox GBDYNgroup03         width:(DYNiniExplorerWidth - 21) pos:[4,111]  height:61
  checkbox CKDYNcastShadow      pos:[11,130] align:#left
  checkbox CKDYNdisplayBox      pos:[11,150] align:#left

  groupbox GBDYNgroup04         pos:[4,176]  width:(DYNiniExplorerWidth - 21) height:48
  checkbutton CBDYNlinked       pos:[11,195] width:(DYNiniExplorerWidth - 35) highlightColor:DYNINIhighlightColor

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNvehicleParams open do
  (
    DYNvehicleParams.title = DYNuiRolloutNames[2]
    CKDYNcastShadow.text   = DYNuiResourcesLabels[20]
    CKDYNdisplayBox.text   = DYNuiResourcesLabels[21]
    GBDYNgroup01.text      = DYNuiResourcesGroups[20]
    GBDYNgroup02.text      = DYNuiResourcesGroups[21]
    GBDYNgroup03.text      = DYNuiResourcesGroups[22]
    GBDYNgroup04.text      = DYNuiResourcesGroups[1]
  )
  on DYNvehicleParams close do
  (
    LOCobj = undefined
  )

  on DDVISvehType selected arg do
  (
  )

  on DDVISobjectParam selected arg do
  (
    undo label:(DYNuiResourcesUndoLabels[8]) on (DYNFUNchangeVehicleBody LOCobj arg)
  )

  on CKDYNcastShadow changed arg do
  (
    undo label:(DYNuiResourcesUndoLabels[8]) on
    (
      LOCobj.castShadows = arg
      try (LOCobj.isGIoccluder = arg) catch ()
      local LOCinstances
      Instancemgr.getInstances LOCobj &LOCinstances
      for i in LOCinstances do (if isValidNode i then (i.castShadows = arg; try (i.isGIoccluder = arg) catch ()))
      for i in LOCobj.children do (if isValidNode i then (i.castShadows = arg; try (i.isGIoccluder = arg) catch ()))
    )
  )
  on CKDYNdisplayBox changed arg do
  (
    undo label:(DYNuiResourcesUndoLabels[8]) on
    (
      LOCobj.boxMode = arg
      local LOCinstances
      Instancemgr.getInstances LOCobj &LOCinstances
      for i in LOCinstances do (if isValidNode i then (i.boxMode = arg))
      for i in LOCobj.children do (if isValidNode i then (i.boxMode = arg))
    )
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNvehicleParams LOCobj 1 false
      select LOCobj
    )
  )
)
